#include "SAXTest.h"
#include "SAXTest_Rsc.h"
#include "SAXLib.h"

UInt32 g_locatorID;
MemHandle	g_ParseStatus;

void CH_SetDocumentLocator(UInt32 locatorID)
{
	g_locatorID=locatorID;
}

void CH_StartElement(Char* uri,Char* localName,Char* qName,UInt32 attrID)
{
	Char* pURI=SAXLib_DL_GetSystemId(g_libRef,g_locatorID);
	
	if (FrmCustomAlert(ElementStartAlert,qName,"","")==1) // show attributes
	{
		Char	numStr[maxStrIToALen];
		UInt16 attrNum=SAXLib_Attr_GetLength(g_libRef,attrID);
		StrIToA(numStr,attrNum);
		FrmCustomAlert(AttributesCommonAlert,qName,numStr,"");
		
		for (Int16 i=0;i<attrNum;i++)
		{
			Char* attrName=SAXLib_Attr_GetQName(g_libRef,attrID,i);
			Char* attrValue=SAXLib_Attr_GetValueByIndex(g_libRef,attrID,i);
			
			StrIToA(numStr,i+1);
			FrmCustomAlert(AttributeDetailsAlert,numStr,attrName,attrValue);
			
			MemPtrFree(attrName);
			MemPtrFree(attrValue);
		}
	}
	qName=0;
	uri=0;
	localName=0;
}

void CH_EndElement(Char* uri,Char* localName,Char* qName)
{
	FrmCustomAlert(ElementEndAlert,qName,"","");
}

void CH_EndDocument()
{
}

Boolean CH_Characters(Char* ch,Int16 start,Int16 length,UInt32 currentState)
{
	Boolean retVal=true;
	Char* pString=(Char*)MemPtrNew(length+1);
	StrNCopy(pString,ch+start,length);
	pString[length]=0x00;
	if (FrmCustomAlert(CharactersAlert,pString,"","")==1)
	{
		SAXLibGetCurrentState(g_libRef,currentState,&g_ParseStatus);
		retVal=false;
	}
	MemPtrFree(pString);
	
	return retVal;
}
